unit aspxDelphiWCL.Designer;

{
Copyright:  aspxDelphi.net All rights reserved. Use freely.

Zarko Gajic
http://aspxdelphi.net
http://delphi.about.com

}

interface

uses
  System.Web.UI, System.Web.UI.Design, System.ComponentModel,System.ComponentModel.Design, System.Text;

type
  //composite Control Designer
  Designer = class(ControlDesigner)
  strict protected
    function GetEmptyDesignTimeHtml : string; override;
    function GetErrorDesignTimeHtml(e:Exception): string; override;
  public
    constructor Create;
    function GetDesignTimeHtml : string; override;
    procedure Initialize(component: IComponent); override;
  end;

implementation

uses aspxDelphiWCL.autopostback;

constructor Designer.Create;
begin
  inherited;
end;

function Designer.GetDesignTimeHtml: string;
var
  ctrls: ControlCollection;
begin
  ctrls := (Component as Control).Controls;
  Result := inherited GetDesignTimeHtml;
end;

function Designer.GetEmptyDesignTimeHtml: string;
begin
  Result := CreatePlaceHolderDesignTimeHtml(typeof(Component).ToString + ' control.');
end;

function Designer.GetErrorDesignTimeHtml(e: Exception): string;
var
  sb : StringBuilder;
begin
  sb := StringBuilder.Create;
  sb.Append('Error rendering ' + typeof(Component).ToString);
  sb.Append('<br>');
  sb.Append('Exception: ' + e.Source);
  sb.Append('<br>');
  sb.Append('Exception message: ' + e.Message);

  result := CreatePlaceHolderDesignTimeHtml(sb.ToString);
end;

{ AutoPostbackDesigner }


procedure Designer.Initialize(component: IComponent);
begin
  inherited;
  if not ((component IS Control) AND (component IS INamingContainer)) then
  begin
    raise ArgumentException.Create('Component must be a container control', 'component');
  end;
  inherited Initialize(component);
end;

end.
